"""Type stubs for BasalamClient - provides IDE autocomplete support."""
from typing import Any, Dict, List, Optional, Union, BinaryIO
from .auth import BaseAuth, Scope
from .config import BasalamConfig

class BasalamClient:
    """Main client for interacting with the Basalam API."""

    def __init__(self, auth: BaseAuth, config: Optional[BasalamConfig] = None) -> None: ...

    # Service attributes
    core: Any
    chat: Any
    order: Any
    order_processing: Any
    search: Any
    upload: Any
    wallet: Any
    webhook: Any

    # Context manager and auth methods
    async def __aenter__(self) -> BasalamClient: ...
    async def __aexit__(self, exc_type: Any, exc_val: Any, exc_tb: Any) -> None: ...
    def has_scope(self, scope: Union[str, Scope]) -> bool: ...
    def get_granted_scopes(self) -> List[str]: ...
    async def refresh_auth_token(self) -> None: ...
    def refresh_auth_token_sync(self) -> None: ...

    # Service methods (dynamically delegated)
    async def create_discount(vendor_id: int, request: CreateDiscountRequestSchema ) -> Dict[str, Any]: ...
    def create_discount_sync(vendor_id: int, request: CreateDiscountRequestSchema ) -> Dict[str, Any]: ...
    async def create_product(vendor_id: int, request: ProductRequestSchema, photo_files: Optional[List[BinaryIO]] = None, video_file: Optional[BinaryIO] = None ) -> ProductResponseSchema: ...
    def create_product_sync(vendor_id: int, request: ProductRequestSchema, photo_files: Optional[List[BinaryIO]] = None, video_file: Optional[BinaryIO] = None ) -> ProductResponseSchema: ...
    async def create_products_bulk_action_request(vendor_id: int, request: BulkProductsUpdateRequestSchema ) -> BulkProductsUpdateResponseSchema: ...
    def create_products_bulk_action_request_sync(vendor_id: int, request: BulkProductsUpdateRequestSchema ) -> BulkProductsUpdateResponseSchema: ...
    async def create_user_bank_account(user_id: int, request: UserCardsSchema, prefer: Optional[str] = "return=minimal" ) -> Dict[str, Any]: ...
    def create_user_bank_account_sync(user_id: int, request: UserCardsSchema, prefer: Optional[str] = "return=minimal" ) -> Dict[str, Any]: ...
    async def create_user_mobile_change_request(user_id: int, request: ChangeUserMobileRequestSchema ) -> ResultResponse: ...
    def create_user_mobile_change_request_sync(user_id: int, request: ChangeUserMobileRequestSchema ) -> ResultResponse: ...
    async def create_user_mobile_confirmation_request(user_id: int ) -> ResultResponse: ...
    def create_user_mobile_confirmation_request_sync(user_id: int ) -> ResultResponse: ...
    async def create_vendor(user_id: int, request: CreateVendorSchema ) -> PublicVendorResponse: ...
    async def create_vendor_mobile_change_confirmation(vendor_id: int, request: ChangeVendorMobileConfirmSchema ) -> ResultResponse: ...
    def create_vendor_mobile_change_confirmation_sync(vendor_id: int, request: ChangeVendorMobileConfirmSchema ) -> ResultResponse: ...
    async def create_vendor_mobile_change_request(vendor_id: int, request: ChangeVendorMobileRequestSchema ) -> ResultResponse: ...
    def create_vendor_mobile_change_request_sync(vendor_id: int, request: ChangeVendorMobileRequestSchema ) -> ResultResponse: ...
    def create_vendor_sync(user_id: int, request: CreateVendorSchema ) -> PublicVendorResponse: ...
    async def delete_discount(vendor_id: int, request: DeleteDiscountRequestSchema ) -> Dict[str, Any]: ...
    def delete_discount_sync(vendor_id: int, request: DeleteDiscountRequestSchema ) -> Dict[str, Any]: ...
    async def delete_user_bank_account(user_id: int, bank_account_id: int ) -> Dict[str, Any]: ...
    def delete_user_bank_account_sync(user_id: int, bank_account_id: int ) -> Dict[str, Any]: ...
    async def get_categories() -> CategoriesResponse: ...
    def get_categories_sync() -> CategoriesResponse: ...
    async def get_category(category_id: int) -> CategoryResponse: ...
    async def get_category_attributes(category_id: int, product_id: Optional[int] = None, vendor_id: Optional[int] = None, exclude_multi_selects: bool = True ) -> AttributesResponse: ...
    def get_category_attributes_sync(category_id: int, product_id: Optional[int] = None, vendor_id: Optional[int] = None, exclude_multi_selects: bool = True ) -> AttributesResponse: ...
    def get_category_sync(category_id: int) -> CategoryResponse: ...
    async def get_current_user() -> PrivateUserResponse: ...
    def get_current_user_sync() -> PrivateUserResponse: ...
    async def get_default_shipping_methods() -> List[ShippingMethodResponse]: ...
    def get_default_shipping_methods_sync() -> List[ShippingMethodResponse]: ...
    async def get_product(product_id: int, prefer: Optional[str] = "return=minimal" ) -> ProductResponseSchema: ...
    async def get_product_shelves(product_id: int ) -> List[ProductShelfResponse]: ...
    def get_product_shelves_sync(product_id: int ) -> List[ProductShelfResponse]: ...
    def get_product_sync(product_id: int, prefer: Optional[str] = "return=minimal" ) -> ProductResponseSchema: ...
    async def get_products(query_params: Optional[GetProductsQuerySchema] = None, prefer: Optional[str] = "return=minimal" ) -> ProductListResponse: ...
    async def get_products_bulk_action_requests(vendor_id: int, page: int = 1, per_page: int = 30 ) -> BulkProductsUpdatesListResponse: ...
    async def get_products_bulk_action_requests_count(vendor_id: int ) -> BulkProductsUpdatesCountResponse: ...
    def get_products_bulk_action_requests_count_sync(vendor_id: int ) -> BulkProductsUpdatesCountResponse: ...
    def get_products_bulk_action_requests_sync(vendor_id: int, page: int = 1, per_page: int = 30 ) -> BulkProductsUpdatesListResponse: ...
    def get_products_sync(query_params: Optional[GetProductsQuerySchema] = None, prefer: Optional[str] = "return=minimal" ) -> ProductListResponse: ...
    async def get_products_unsuccessful_bulk_action_requests(request_id: int, page: int = 1, per_page: int = 20 ) -> UnsuccessfulBulkUpdateProducts: ...
    def get_products_unsuccessful_bulk_action_requests_sync(request_id: int, page: int = 1, per_page: int = 20 ) -> UnsuccessfulBulkUpdateProducts: ...
    async def get_shipping_methods(ids: Optional[List[int]] = None, vendor_ids: Optional[List[int]] = None, include_deleted: Optional[bool] = None, page: int = 1, per_page: int = 10 ) -> ShippingMethodListResponse: ...
    def get_shipping_methods_sync(ids: Optional[List[int]] = None, vendor_ids: Optional[List[int]] = None, include_deleted: Optional[bool] = None, page: int = 1, per_page: int = 10 ) -> ShippingMethodListResponse: ...
    async def get_user_bank_accounts(user_id: int, prefer: Optional[str] = "return=minimal" ) -> List[Dict[str, Any]]: ...
    def get_user_bank_accounts_sync(user_id: int, prefer: Optional[str] = "return=minimal" ) -> List[Dict[str, Any]]: ...
    async def get_vendor(vendor_id: int, prefer: Optional[str] = "return=minimal" ) -> Union[PublicVendorResponse, PrivateVendorResponse]: ...
    async def get_vendor_products(vendor_id: int, query_params: Optional[GetVendorProductsSchema] = None ) -> ProductListResponse: ...
    def get_vendor_products_sync(vendor_id: int, query_params: Optional[GetVendorProductsSchema] = None ) -> ProductListResponse: ...
    def get_vendor_sync(vendor_id: int, prefer: Optional[str] = "return=minimal" ) -> Union[PublicVendorResponse, PrivateVendorResponse]: ...
    async def get_working_shipping_methods(vendor_id: int ) -> List[ShippingMethodResponse]: ...
    def get_working_shipping_methods_sync(vendor_id: int ) -> List[ShippingMethodResponse]: ...
    async def update_bulk_products(vendor_id: int, request: BatchUpdateProductsRequest ) -> List[UpdateProductResponseItem]: ...
    def update_bulk_products_sync(vendor_id: int, request: BatchUpdateProductsRequest ) -> List[UpdateProductResponseItem]: ...
    async def update_product(product_id: int, request: ProductRequestSchema, photo_files: Optional[List[BinaryIO]] = None, video_file: Optional[BinaryIO] = None ) -> ProductResponseSchema: ...
    def update_product_sync(product_id: int, request: ProductRequestSchema, photo_files: Optional[List[BinaryIO]] = None, video_file: Optional[BinaryIO] = None ) -> ProductResponseSchema: ...
    async def update_product_variation(product_id: int, variation_id: int, request: UpdateProductVariationSchema ) -> ProductResponseSchema: ...
    def update_product_variation_sync(product_id: int, variation_id: int, request: UpdateProductVariationSchema ) -> ProductResponseSchema: ...
    async def update_shipping_methods(vendor_id: int, request: UpdateShippingMethodSchema ) -> List[ShippingMethodResponse]: ...
    def update_shipping_methods_sync(vendor_id: int, request: UpdateShippingMethodSchema ) -> List[ShippingMethodResponse]: ...
    async def update_user_bank_account(bank_account_id: int, request: UpdateUserBankInformationSchema ) -> Dict[str, Any]: ...
    def update_user_bank_account_sync(bank_account_id: int, request: UpdateUserBankInformationSchema ) -> Dict[str, Any]: ...
    async def update_user_verification(user_id: int, request: UserVerificationSchema ) -> PrivateUserResponse: ...
    def update_user_verification_sync(user_id: int, request: UserVerificationSchema ) -> PrivateUserResponse: ...
    async def update_vendor(vendor_id: int, request: UpdateVendorSchema ) -> PublicVendorResponse: ...
    async def update_vendor_status(vendor_id: int, request: UpdateVendorStatusSchema ) -> UpdateVendorStatusResponse: ...
    def update_vendor_status_sync(vendor_id: int, request: UpdateVendorStatusSchema ) -> UpdateVendorStatusResponse: ...
    def update_vendor_sync(vendor_id: int, request: UpdateVendorSchema ) -> PublicVendorResponse: ...
    async def verify_user_bank_account(user_id: int, request: UserVerifyBankInformationSchema ) -> Dict[str, Any]: ...
    async def verify_user_bank_account_otp(user_id: int, request: UserCardsOtpSchema ) -> Dict[str, Any]: ...
    def verify_user_bank_account_otp_sync(user_id: int, request: UserCardsOtpSchema ) -> Dict[str, Any]: ...
    def verify_user_bank_account_sync(user_id: int, request: UserVerifyBankInformationSchema ) -> Dict[str, Any]: ...
    async def verify_user_mobile_change_request(user_id: int, request: ChangeUserMobileConfirmSchema ) -> ResultResponse: ...
    def verify_user_mobile_change_request_sync(user_id: int, request: ChangeUserMobileConfirmSchema ) -> ResultResponse: ...
    async def verify_user_mobile_confirmation_request(user_id: int, request: ConfirmCurrentUserMobileConfirmSchema ) -> ResultResponse: ...
    def verify_user_mobile_confirmation_request_sync(user_id: int, request: ConfirmCurrentUserMobileConfirmSchema ) -> ResultResponse: ...
    async def create_chat(request: CreateChatRequest, x_creation_tags: Optional[str] = None ) -> CreateChatResponse: ...
    def create_chat_sync(request: CreateChatRequest, x_creation_tags: Optional[str] = None ) -> CreateChatResponse: ...
    async def create_message(request: MessageRequest, user_agent: Optional[str] = None ) -> MessageResponse: ...
    def create_message_sync(request: MessageRequest, user_agent: Optional[str] = None ) -> MessageResponse: ...
    async def get_chats(request: GetChatsRequest ) -> ChatListResponse: ...
    def get_chats_sync(request: GetChatsRequest ) -> ChatListResponse: ...
    async def get_messages(request: GetMessagesRequest ) -> GetMessagesResponse: ...
    def get_messages_sync(request: GetMessagesRequest ) -> GetMessagesResponse: ...
    async def create_invoice_payment(invoice_id: int, request: CreatePaymentRequestModel ) -> Dict[str, Any]: ...
    def create_invoice_payment_sync(invoice_id: int, request: CreatePaymentRequestModel ) -> Dict[str, Any]: ...
    async def create_payment_callback(payment_id: int, request: PaymentVerifyRequestModel ) -> Dict[str, Any]: ...
    def create_payment_callback_sync(payment_id: int, request: PaymentVerifyRequestModel ) -> Dict[str, Any]: ...
    async def get_baskets(refresh: bool = False) -> BasketResponse: ...
    def get_baskets_sync(refresh: bool = False) -> BasketResponse: ...
    async def get_payable_invoices(page: int, per_page: int ) -> Dict[str, Any]: ...
    def get_payable_invoices_sync(page: int, per_page: int ) -> Dict[str, Any]: ...
    async def get_payment_callback(payment_id: int, request: PaymentCallbackRequestModel ) -> Dict[str, Any]: ...
    def get_payment_callback_sync(payment_id: int, request: PaymentCallbackRequestModel ) -> Dict[str, Any]: ...
    async def get_product_variation_status(product_id: int) -> Dict[str, Any]: ...
    def get_product_variation_status_sync(product_id: int) -> Dict[str, Any]: ...
    async def get_unpaid_invoices(invoice_id: Optional[int] = None, status: Optional[UnpaidInvoiceStatusEnum] = None, page: int = 1, per_page: int = 20, sort: OrderEnum = OrderEnum.DESC ) -> Dict[str, Any]: ...
    def get_unpaid_invoices_sync(invoice_id: Optional[int] = None, status: Optional[UnpaidInvoiceStatusEnum] = None, page: int = 1, per_page: int = 20, sort: OrderEnum = OrderEnum.DESC ) -> Dict[str, Any]: ...
    async def get_customer_order(order_id: int) -> Order: ...
    async def get_customer_order_item(item_id: int) -> CustomerItemResponse: ...
    def get_customer_order_item_sync(item_id: int) -> CustomerItemResponse: ...
    async def get_customer_order_items(filters: Optional[ItemFilter] = None ) -> CustomerItemsResponse: ...
    def get_customer_order_items_sync(filters: Optional[ItemFilter] = None ) -> CustomerItemsResponse: ...
    async def get_customer_order_parcel_hints(order_id: int) -> ParcelHintsResponse: ...
    def get_customer_order_parcel_hints_sync(order_id: int) -> ParcelHintsResponse: ...
    def get_customer_order_sync(order_id: int) -> Order: ...
    async def get_customer_orders(filters: Optional[OrderFilter] = None ) -> OrdersResponse: ...
    def get_customer_orders_sync(filters: Optional[OrderFilter] = None ) -> OrdersResponse: ...
    async def get_order_parcel(parcel_id: int) -> ParcelResponse: ...
    def get_order_parcel_sync(parcel_id: int) -> ParcelResponse: ...
    async def get_orders_stats(resource_count: ResourceStats, vendor_id: Optional[int] = None, product_id: Optional[int] = None, customer_id: Optional[int] = None, coupon_code: Optional[str] = None, cache_control: Optional[str] = None ) -> OrderStatsResponse: ...
    def get_orders_stats_sync(resource_count: ResourceStats, vendor_id: Optional[int] = None, product_id: Optional[int] = None, customer_id: Optional[int] = None, coupon_code: Optional[str] = None, cache_control: Optional[str] = None ) -> OrderStatsResponse: ...
    async def get_vendor_orders_parcels(filters: Optional[OrderParcelFilter] = None ) -> ParcelsResponse: ...
    def get_vendor_orders_parcels_sync(filters: Optional[OrderParcelFilter] = None ) -> ParcelsResponse: ...
    async def search_products(request: ProductSearchModel) -> Dict[str, Any]: ...
    def search_products_sync(request: ProductSearchModel) -> Dict[str, Any]: ...
    async def upload_file(file: BinaryIO, file_type: UserUploadFileTypeEnum, custom_unique_name: Optional[str] = None, expire_minutes: Optional[int] = None ) -> FileResponse: ...
    def upload_file_sync(file: BinaryIO, file_type: UserUploadFileTypeEnum, custom_unique_name: Optional[str] = None, expire_minutes: Optional[int] = None ) -> FileResponse: ...
    async def can_rollback_refund(refund_reason: int, refund_reference_id: int, x_operator_id: Optional[int] = None ) -> CanRollbackRefundResponse: ...
    def can_rollback_refund_sync(refund_reason: int, refund_reference_id: int, x_operator_id: Optional[int] = None ) -> CanRollbackRefundResponse: ...
    async def create_expense(user_id: int, request: SpendCreditRequest, x_operator_id: Optional[int] = None ) -> SpendResponse: ...
    async def create_expense_from_credit(user_id: int, credit_id: int, request: SpendSpecificCreditRequest, x_operator_id: Optional[int] = None ) -> SpendResponse: ...
    def create_expense_from_credit_sync(user_id: int, credit_id: int, request: SpendSpecificCreditRequest, x_operator_id: Optional[int] = None ) -> SpendResponse: ...
    def create_expense_sync(user_id: int, request: SpendCreditRequest, x_operator_id: Optional[int] = None ) -> SpendResponse: ...
    async def create_refund(request: RefundRequest, x_operator_id: Optional[int] = None ) -> Union[CreditCreationResponse, SpendResponse]: ...
    def create_refund_sync(request: RefundRequest, x_operator_id: Optional[int] = None ) -> Union[CreditCreationResponse, SpendResponse]: ...
    async def delete_expense(user_id: int, expense_id: int, rollback_reason_id: int, x_operator_id: Optional[int] = None ) -> SpendResponse: ...
    async def delete_expense_by_ref(user_id: int, reason_id: int, reference_id: int, rollback_reason_id: int, x_operator_id: Optional[int] = None ) -> SpendResponse: ...
    def delete_expense_by_ref_sync(user_id: int, reason_id: int, reference_id: int, rollback_reason_id: int, x_operator_id: Optional[int] = None ) -> SpendResponse: ...
    def delete_expense_sync(user_id: int, expense_id: int, rollback_reason_id: int, x_operator_id: Optional[int] = None ) -> SpendResponse: ...
    async def get_balance(user_id: int, filters: List[BalanceFilter] = None, x_operator_id: Optional[int] = None ) -> Dict[str, Any]: ...
    def get_balance_sync(user_id: int, filters: List[BalanceFilter] = None, x_operator_id: Optional[int] = None ) -> Dict[str, Any]: ...
    async def get_expense(user_id: int, expense_id: int, x_operator_id: Optional[int] = None ) -> SpendResponse: ...
    async def get_expense_by_ref(user_id: int, reason_id: int, reference_id: int, x_operator_id: Optional[int] = None ) -> SpendResponse: ...
    def get_expense_by_ref_sync(user_id: int, reason_id: int, reference_id: int, x_operator_id: Optional[int] = None ) -> SpendResponse: ...
    def get_expense_sync(user_id: int, expense_id: int, x_operator_id: Optional[int] = None ) -> SpendResponse: ...
    async def get_transactions(user_id: int, page: int = 1, per_page: int = 50, x_operator_id: Optional[int] = None ) -> HistoryPaginationResponse: ...
    def get_transactions_sync(user_id: int, page: int = 1, per_page: int = 50, x_operator_id: Optional[int] = None ) -> HistoryPaginationResponse: ...
    async def rollback_refund(request: RollbackRefundRequest, x_operator_id: Optional[int] = None ) -> SpendResponse: ...
    def rollback_refund_sync(request: RollbackRefundRequest, x_operator_id: Optional[int] = None ) -> SpendResponse: ...
    async def create_webhook(request: CreateWebhookRequest) -> WebhookResource: ...
    async def create_webhook_service(request: CreateServiceRequest) -> ServiceResource: ...
    def create_webhook_service_sync(request: CreateServiceRequest) -> ServiceResource: ...
    def create_webhook_sync(request: CreateWebhookRequest) -> WebhookResource: ...
    async def delete_webhook(webhook_id: int) -> DeleteWebhookResponse: ...
    def delete_webhook_sync(webhook_id: int) -> DeleteWebhookResponse: ...
    async def get_registered_webhooks(page: Optional[int] = 1, per_page: Optional[int] = 10, service_id: Optional[int] = None ) -> WebhookRegisteredOnListResource: ...
    def get_registered_webhooks_sync(page: Optional[int] = 1, per_page: Optional[int] = 10, service_id: Optional[int] = None ) -> WebhookRegisteredOnListResource: ...
    async def get_webhook_customers(page: Optional[int] = 1, per_page: Optional[int] = 10, webhook_id: Optional[int] = None ) -> ClientListResource: ...
    def get_webhook_customers_sync(page: Optional[int] = 1, per_page: Optional[int] = 10, webhook_id: Optional[int] = None ) -> ClientListResource: ...
    async def get_webhook_events() -> EventListResource: ...
    def get_webhook_events_sync() -> EventListResource: ...
    async def get_webhook_logs(webhook_id: int) -> WebhookLogListResource: ...
    def get_webhook_logs_sync(webhook_id: int) -> WebhookLogListResource: ...
    async def get_webhook_services() -> ServiceListResource: ...
    def get_webhook_services_sync() -> ServiceListResource: ...
    async def get_webhooks(service_id: Optional[int] = None, event_ids: Optional[str] = None ) -> WebhookListResource: ...
    def get_webhooks_sync(service_id: Optional[int] = None, event_ids: Optional[str] = None ) -> WebhookListResource: ...
    async def register_webhook(request: RegisterClientRequest) -> ClientResource: ...
    def register_webhook_sync(request: RegisterClientRequest) -> ClientResource: ...
    async def unregister_webhook(request: UnRegisterClientRequest) -> UnRegisterClientResponse: ...
    def unregister_webhook_sync(request: UnRegisterClientRequest) -> UnRegisterClientResponse: ...
    async def update_webhook(webhook_id: int, request: UpdateWebhookRequest ) -> WebhookResource: ...
    def update_webhook_sync(webhook_id: int, request: UpdateWebhookRequest ) -> WebhookResource: ...